/*
 * MATLAB Compiler: 3.0
 * Date: Mon Nov 03 13:00:57 2003
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-m" "-W" "main" "-L"
 * "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "DancingMonkeys" 
 */
#include "lp2bp.h"
#include "libmatlbm.h"
#include "libmmfile.h"
static mxArray * _mxarray0_;
static mxArray * _mxarray1_;

void InitializeModule_lp2bp(void) {
    _mxarray0_ = mclInitializeDouble(2.0);
    _mxarray1_ = mclInitializeDouble(1.0);
}

void TerminateModule_lp2bp(void) {
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * Mlp2bp(mxArray * * bt,
                        mxArray * * ct,
                        mxArray * * dt,
                        int nargout_,
                        mxArray * a,
                        mxArray * b,
                        mxArray * c,
                        mxArray * d,
                        mxArray * wo,
                        mxArray * bw);

_mexLocalFunctionTable _local_function_table_lp2bp
  = { 0, (mexFunctionTableEntry *)NULL };

/*
 * The function "mlfLp2bp" contains the normal interface for the "lp2bp"
 * M-function from file "c:\matlab65\toolbox\signal\signal\lp2bp.m" (lines
 * 1-48). This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
mxArray * mlfLp2bp(mxArray * * bt,
                   mxArray * * ct,
                   mxArray * * dt,
                   mxArray * a,
                   mxArray * b,
                   mxArray * c,
                   mxArray * d,
                   mxArray * wo,
                   mxArray * bw) {
    int nargout = 1;
    mxArray * at = NULL;
    mxArray * bt__ = NULL;
    mxArray * ct__ = NULL;
    mxArray * dt__ = NULL;
    mlfEnterNewContext(3, 6, bt, ct, dt, a, b, c, d, wo, bw);
    if (bt != NULL) {
        ++nargout;
    }
    if (ct != NULL) {
        ++nargout;
    }
    if (dt != NULL) {
        ++nargout;
    }
    at = Mlp2bp(&bt__, &ct__, &dt__, nargout, a, b, c, d, wo, bw);
    mlfRestorePreviousContext(3, 6, bt, ct, dt, a, b, c, d, wo, bw);
    if (bt != NULL) {
        mclCopyOutputArg(bt, bt__);
    } else {
        mxDestroyArray(bt__);
    }
    if (ct != NULL) {
        mclCopyOutputArg(ct, ct__);
    } else {
        mxDestroyArray(ct__);
    }
    if (dt != NULL) {
        mclCopyOutputArg(dt, dt__);
    } else {
        mxDestroyArray(dt__);
    }
    return mlfReturnValue(at);
}

/*
 * The function "mlxLp2bp" contains the feval interface for the "lp2bp"
 * M-function from file "c:\matlab65\toolbox\signal\signal\lp2bp.m" (lines
 * 1-48). The feval function calls the implementation version of lp2bp through
 * this function. This function processes any input arguments and passes them
 * to the implementation version of the function, appearing above.
 */
void mlxLp2bp(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[6];
    mxArray * mplhs[4];
    int i;
    if (nlhs > 4) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: lp2bp Line: 1 Column: 1 The function \"lp2bp"
            "\" was called with more than the declared number of outputs (4)."),
          NULL);
    }
    if (nrhs > 6) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: lp2bp Line: 1 Column: 1 The function \"lp2bp"
            "\" was called with more than the declared number of inputs (6)."),
          NULL);
    }
    for (i = 0; i < 4; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 6 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 6; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(
      0, 6, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4], mprhs[5]);
    mplhs[0]
      = Mlp2bp(
          &mplhs[1],
          &mplhs[2],
          &mplhs[3],
          nlhs,
          mprhs[0],
          mprhs[1],
          mprhs[2],
          mprhs[3],
          mprhs[4],
          mprhs[5]);
    mlfRestorePreviousContext(
      0, 6, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4], mprhs[5]);
    plhs[0] = mplhs[0];
    for (i = 1; i < 4 && i < nlhs; ++i) {
        plhs[i] = mplhs[i];
    }
    for (; i < 4; ++i) {
        mxDestroyArray(mplhs[i]);
    }
}

/*
 * The function "Mlp2bp" is the implementation version of the "lp2bp"
 * M-function from file "c:\matlab65\toolbox\signal\signal\lp2bp.m" (lines
 * 1-48). It contains the actual compiled code for that M-function. It is a
 * static function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function [at,bt,ct,dt] = lp2bp(a,b,c,d,wo,bw)
 */
static mxArray * Mlp2bp(mxArray * * bt,
                        mxArray * * ct,
                        mxArray * * dt,
                        int nargout_,
                        mxArray * a,
                        mxArray * b,
                        mxArray * c,
                        mxArray * d,
                        mxArray * wo,
                        mxArray * bw) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_lp2bp);
    int nargin_ = mclNargin(6, a, b, c, d, wo, bw, NULL);
    mxArray * at = NULL;
    mxArray * den = NULL;
    mxArray * num = NULL;
    mxArray * k = NULL;
    mxArray * z = NULL;
    mxArray * q = NULL;
    mxArray * mc = NULL;
    mxArray * nb = NULL;
    mxArray * ma = NULL;
    mxArray * ans = NULL;
    mclCopyArray(&a);
    mclCopyArray(&b);
    mclCopyArray(&c);
    mclCopyArray(&d);
    mclCopyArray(&wo);
    mclCopyArray(&bw);
    /*
     * %LP2BP Lowpass to bandpass analog filter transformation.
     * %   [NUMT,DENT] = LP2BP(NUM,DEN,Wo,Bw) transforms the lowpass filter
     * %   prototype NUM(s)/DEN(s) with unity cutoff frequency to a
     * %   bandpass filter with center frequency Wo and bandwidth Bw.
     * %   [AT,BT,CT,DT] = LP2BP(A,B,C,D,Wo,Bw) does the same when the
     * %   filter is described in state-space form.
     * %
     * %   See also BILINEAR, IMPINVAR, LP2LP, LP2BS and LP2HP
     * 
     * %   Author(s): J.N. Little and G.F. Franklin, 8-4-87
     * %   Copyright 1988-2002 The MathWorks, Inc.
     * %   $Revision: 1.7 $  $Date: 2002/03/28 17:28:42 $
     * 
     * if nargin == 4		% Transfer function case
     */
    if (nargin_ == 4) {
        /*
         * % handle column vector inputs: convert to rows
         * if size(a,2) == 1
         */
        if (mclEqBool(
              mlfSize(mclValueVarargout(), mclVa(a, "a"), _mxarray0_),
              _mxarray1_)) {
            /*
             * a = a(:).';
             */
            mlfAssign(
              &a,
              mlfTranspose(mclArrayRef1(mclVa(a, "a"), mlfCreateColonIndex())));
        /*
         * end
         */
        }
        /*
         * if size(b,2) == 1
         */
        if (mclEqBool(
              mlfSize(mclValueVarargout(), mclVa(b, "b"), _mxarray0_),
              _mxarray1_)) {
            /*
             * b = b(:).';
             */
            mlfAssign(
              &b,
              mlfTranspose(mclArrayRef1(mclVa(b, "b"), mlfCreateColonIndex())));
        /*
         * end
         */
        }
        /*
         * % Transform to state-space
         * wo = c;
         */
        mlfAssign(&wo, mclVa(c, "c"));
        /*
         * bw = d;
         */
        mlfAssign(&bw, mclVa(d, "d"));
        /*
         * [a,b,c,d] = tf2ss(a,b);
         */
        mlfAssign(&a, mlfTf2ss(&b, &c, &d, mclVa(a, "a"), mclVa(b, "b")));
    /*
     * end
     */
    }
    /*
     * 
     * error(abcdchk(a,b,c,d));
     */
    mlfError(
      mlfAbcdchk(
        NULL,
        NULL,
        NULL,
        NULL,
        mclVa(a, "a"),
        mclVa(b, "b"),
        mclVa(c, "c"),
        mclVa(d, "d")),
      NULL);
    /*
     * [ma,nb] = size(b);
     */
    mlfSize(mlfVarargout(&ma, &nb, NULL), mclVa(b, "b"), NULL);
    /*
     * [mc,ma] = size(c);
     */
    mlfSize(mlfVarargout(&mc, &ma, NULL), mclVa(c, "c"), NULL);
    /*
     * 
     * % Transform lowpass to bandpass
     * q = wo/bw;
     */
    mlfAssign(&q, mclMrdivide(mclVa(wo, "wo"), mclVa(bw, "bw")));
    /*
     * at = wo*[a/q eye(ma); -eye(ma) zeros(ma)];
     */
    mlfAssign(
      &at,
      mclMtimes(
        mclVa(wo, "wo"),
        mlfVertcat(
          mlfHorzcat(
            mclMrdivide(mclVa(a, "a"), mclVv(q, "q")),
            mlfEye(mclVv(ma, "ma"), NULL),
            NULL),
          mlfHorzcat(
            mclUminus(mlfEye(mclVv(ma, "ma"), NULL)),
            mlfZeros(mclVv(ma, "ma"), NULL),
            NULL),
          NULL)));
    /*
     * bt = wo*[b/q; zeros(ma,nb)];
     */
    mlfAssign(
      bt,
      mclMtimes(
        mclVa(wo, "wo"),
        mlfVertcat(
          mclMrdivide(mclVa(b, "b"), mclVv(q, "q")),
          mlfZeros(mclVv(ma, "ma"), mclVv(nb, "nb"), NULL),
          NULL)));
    /*
     * ct = [c zeros(mc,ma)];
     */
    mlfAssign(
      ct,
      mlfHorzcat(
        mclVa(c, "c"), mlfZeros(mclVv(mc, "mc"), mclVv(ma, "ma"), NULL), NULL));
    /*
     * dt = d;
     */
    mlfAssign(dt, mclVa(d, "d"));
    /*
     * 
     * if nargin == 4		% Transfer function case
     */
    if (nargin_ == 4) {
        /*
         * % Transform back to transfer function
         * [z,k] = tzero(at,bt,ct,dt);
         */
        mlfAssign(
          &z,
          mlfNTzero(
            2,
            &k,
            mclVv(at, "at"),
            mclVv(*bt, "bt"),
            mclVv(*ct, "ct"),
            mclVv(*dt, "dt")));
        /*
         * num = k * poly(z);
         */
        mlfAssign(&num, mclMtimes(mclVv(k, "k"), mlfPoly(mclVv(z, "z"))));
        /*
         * den = poly(at);
         */
        mlfAssign(&den, mlfPoly(mclVv(at, "at")));
        /*
         * at = num;
         */
        mlfAssign(&at, mclVv(num, "num"));
        /*
         * bt = den;
         */
        mlfAssign(bt, mclVv(den, "den"));
    /*
     * end
     */
    }
    mclValidateOutput(at, 1, nargout_, "at", "lp2bp");
    mclValidateOutput(*bt, 2, nargout_, "bt", "lp2bp");
    mclValidateOutput(*ct, 3, nargout_, "ct", "lp2bp");
    mclValidateOutput(*dt, 4, nargout_, "dt", "lp2bp");
    mxDestroyArray(ans);
    mxDestroyArray(ma);
    mxDestroyArray(nb);
    mxDestroyArray(mc);
    mxDestroyArray(q);
    mxDestroyArray(z);
    mxDestroyArray(k);
    mxDestroyArray(num);
    mxDestroyArray(den);
    mxDestroyArray(bw);
    mxDestroyArray(wo);
    mxDestroyArray(d);
    mxDestroyArray(c);
    mxDestroyArray(b);
    mxDestroyArray(a);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return at;
}
